context("test plot() mthod")

# generate a dataset
#
n  <- 1000
n4 <- 12
n5 <- 7
set.seed(62591415)
x1 <- rnorm(n)
x2 <- rnorm(n)
error <- rnorm(n,0,1)
r4 <- factor( rep(LETTERS[seq(1,n4)],n)[1:n] )
effectsR4 <- rnorm(length(levels(r4)))[as.numeric(r4)]
r5 <- rep(seq(1,n5),n)[1:n]
y <- -20 + 10 * x1 - 40 * x2 + 90 * error + 70 * effectsR4
y.odds <- exp(y)
y.prob <- ifelse(y.odds == Inf,1, y.odds / (1 + y.odds) )
y.bin <- y
for (i in 1:n){
  y.bin[i] <- rbinom(1,1,y.prob[i])
}
datUnsorted <- data.frame(y,y.bin,x1,x2,r4,r5,error)
dat <- datUnsorted[order(r4,r5),]

# generate models
#
lALL <- lm(y ~ x1 + x2 + r4)
lr4 <- lm(y ~ x1 + x2)

pbnmplotn1 <- pbnm(lALL,lr4,nsim=1,test="F")

test_that("plot parameterparameters are valid", {
  expect_error(plot(pbnmplotn1), "not have enough members")
})
