context("test error checks on pbnm() parameters")

# generate a dataset
#
n  <- 1000
n4 <- 12
n5 <- 7
set.seed(62591415)
x1 <- rnorm(n)
x2 <- rnorm(n)
error <- rnorm(n,0,1)
r4 <- factor( rep(LETTERS[seq(1,n4)],n)[1:n] )
effectsR4 <- rnorm(length(levels(r4)))[as.numeric(r4)]
r5 <- rep(seq(1,n5),n)[1:n]
y <- -20 + 10 * x1 - 40 * x2 + 90 * error + 70 * effectsR4
y.odds <- exp(y)
y.prob <- ifelse(y.odds == Inf,1, y.odds / (1 + y.odds) )
y.bin <- y
for (i in 1:n){
  y.bin[i] <- rbinom(1,1,y.prob[i])
}
datUnsorted <- data.frame(y,y.bin,x1,x2,r4,r5,error)
dat <- datUnsorted[order(r4,r5),]

# generate models
#
gALL <- glm(y.bin ~ x1 + x2 + r4, family=binomial, data=dat)
gx1 <- glm(y.bin ~ x2 + r4, family=binomial, data=dat)
gr4 <- glm(y.bin ~ x1 + x2, family=binomial, data=dat)
gQuas <- glm(y.bin ~ x1 + x2, family=quasibinomial, data=dat)

gMALL <- glmer(y.bin ~ x1 + x2 + (1 | r4), family=binomial, data=dat)
gMx1 <- glmer(y.bin ~ x2 + (1 | r4), family=binomial, data=dat)
gMx2 <- glmer(y.bin ~ x1 + (1 | r4), family=binomial, data=dat)
gMRx1c <- glmer(y.bin ~ x1 + x2 + (x1 | r4), family=binomial, data=dat)
gNRx1 <- glmer(y.bin ~ x1 + x2 + (1 | r4) + (x1 - 1 | r4),
               family=binomial, data=dat)
gMx1Rr5 <- glmer(y.bin ~ x2 + (1 | r4) + (1 | r5), family=binomial, data=dat)

lALL <- lm(y ~ x1 + x2 + r4)
lr4 <- lm(y ~ x1 + x2)

lMALL <- lmer(y ~ x1 + x2 + (1 | r4))
lMx2 <- lmer(y ~ x1 + (1 | r4))
lMMLALL <- lmer(y ~ x1 + x2 + (1 | r4),REML=FALSE)
lMMLx2 <- lmer(y ~ x1 + (1 | r4),REML=FALSE)


test_that("models are lm, glm, lmer, glmer", {
  expect_error(pbnm(m1=list("a1","b1"),lALL), "does not inherit")
  expect_error(pbnm(m1=lALL,m0=list("a0")), "does not inherit")
  expect_true(exists("statObs", where=pbnm(lALL,lr4,nsim=2,test="F")))
  expect_true(exists("statObs", where=pbnm(gALL,gr4,nsim=2)))
  expect_true(exists("statObs", where=pbnm(lMMLALL,lMMLx2,nsim=2)))
  expect_true(exists("statObs", where=pbnm(gMALL,gMx2,nsim=2)))
  })

test_that("nsim, seed, cores, task, and progress must be numeric", {
  expect_error(pbnm(lALL,lr4,nsim="char",test="F"), "integer")
  expect_error(pbnm(lALL,lr4,nsim=3.14,test="F"), "integer")
  expect_error(pbnm(lALL,lr4,cores="char",test="F"), "integer")
  expect_error(pbnm(lALL,lr4,cores=3.14,test="F"), "integer")
  expect_error(pbnm(lALL,lr4,cores=0,test="F"), "greater than equal to 1")
  expect_error(pbnm(lALL,lr4,tasks="char",test="F"), "integer")
  expect_error(pbnm(lALL,lr4,tasks=3.14,test="F"), "integer")
  expect_error(pbnm(lALL,lr4,tasks=0,test="F"), "greater than equal to 1")
  expect_error(pbnm(lALL,lr4,tasks=2,cores=3,test="F"), "number of cores")
  expect_error(pbnm(lALL,lr4,seed="char",test="F"), "integer")
  expect_error(pbnm(lALL,lr4,seed=3.14,test="F"), "integer")
  expect_error(pbnm(lALL,lr4,progress="char",test="F"), "integer")
  expect_error(pbnm(lALL,lr4,progress=3.14,test="F"), "integer")
})

test_that("testContrast, fileName, and pbnmName must be character", {
  expect_warning(pbnm(lALL,lr4,testContrast=2,nsim=2,test="F"), "ignored")
  expect_error(pbnm(gMx1,gMx2,nsim=2,testContrast=2), "character")
  expect_error(pbnm(gMx1,gMx2,nsim=2,fileName=2), "character")
  expect_error(pbnm(gMx1,gMx2,nsim=2,pbnmName=2), "character")
})

test_that("save and nestStat must be logical", {
  expect_error(pbnm(lALL,lr4,nsim=2,save=4,test="F"), "logical")
  expect_error(pbnm(lALL,lr4,nsim=2,nestStat=4,test="F"), "logical")
})

test_that("test parameter appropirate for models", {
  expect_error(pbnm(lALL,lr4,nsim=2,test="SILLYTEST"), "F or LRT")
  expect_true(exists("statObs", where=pbnm(lALL,lr4,nsim=2,test="F")))
  expect_error(pbnm(lALL,lr4,nsim=2,test="LRT"), "F")
  expect_true(exists("statObs", where=pbnm(gALL,gr4,nsim=2,test="LRT")))
  expect_error(pbnm(gALL,gr4,nsim=2,test="F"), "LRT")
  expect_true(exists("statObs", where=pbnm(lMMLALL,lMMLx2,nsim=2,test="LRT")))
  expect_error(pbnm(lMMLALL,lMMLx2,nsim=2,test="F"), "LRT")
  expect_true(exists("statObs", where=pbnm(gMALL,gMx2,nsim=2,test="LRT")))
  expect_error(pbnm(gMALL,gMx2,nsim=2,test="F"), "LRT")
})

test_that("REML status of the two models is appropirate", {
  expect_error(pbnm(lMMLALL,lMx2,nsim=2), "REML")
  expect_error(pbnm(lMALL,lMMLx2,nsim=2), "REML")
  expect_error(pbnm(lMALL,lMx2,nsim=2), "ML")
})

pbnmObj <- pbnm(gMx1,gMx2,nsim=5)

test_that("parm parameter in summary, confint, and plot methods", {
  expect_error(summary(pbnmObj,parm=2), "logical")
  expect_error(summary(pbnmObj,parm=TRUE), "No single parameter")
  expect_error(confint(pbnmObj,parm=2), "logical")
  expect_error(confint(pbnmObj,parm=TRUE), "No single parameter")
  expect_error(plot(pbnmObj,parm=2), "logical")
  expect_error(plot(pbnmObj,parm=TRUE), "No single parameter")
})

test_that("level parameter in confint is numeric and on (0,1)", {
  expect_error(confint(pbnmObj,level="char"), "numeric")
  expect_error(confint(pbnmObj,level=0), "lev must be on")
  expect_error(confint(pbnmObj,level=1), "lev must be on")
})
