######################################################
##
##  Test for pbnm (Parametric bootstrap nested models)
##
##  
##
##  September 14, 2015 Mark Banghart
##
##
######################################################

library(Matrix) # needed by lme4
library(lme4)
library(pbnm)
library(parallel)

# generate a dataset
#
n  <- 100
n4 <- 12
n5 <- 7
set.seed(62591415)
x1 <- rnorm(n)
x2 <- rnorm(n)
error <- rnorm(n,0,1)
r4 <- factor( rep(LETTERS[seq(1,n4)],n)[1:n] )
effectsR4 <- rnorm(length(levels(r4)))[as.numeric(r4)]
r5 <- rep(seq(1,n5),n)[1:n]
y <- -20 + 10 * x1 - 40 * x2 + 90 * error + 70 * effectsR4
y.odds <- exp(y)
y.prob <- ifelse(y.odds == Inf,1, y.odds / (1 + y.odds) )
y.bin <- y
for (i in 1:n){
  y.bin[i] <- rbinom(1,1,y.prob[i])
  }
datUnsorted <- data.frame(y,y.bin,x1,x2,r4,r5,error)
dat <- datUnsorted[order(r4,r5),]

outM <- glmer(y.bin ~ x1 + x2 + (1 | r4), family=binomial, data=dat)



# binary models
#
outN <- glm(y.bin ~ x1 + x2, family=binomial, data=dat)

outF <- glm(y.bin ~ x1 + x2 + r4, family=binomial, data=dat)

outFx1 <- glm(y.bin ~ x2 + r4, family=binomial, data=dat)

outFr4 <- glm(y.bin ~ x1 + x2, family=binomial, data=dat)

outM <- glmer(y.bin ~ x1 + x2 + (1 | r4), family=binomial, data=dat)

outM2 <- glmer(y.bin ~ x1 + x2 + (x1 | r4), family=binomial, data=dat)
outM3 <- glmer(y.bin ~ x1 + x2 + (1 | r4) + (x1 - 1 | r4),
               family=binomial, data=dat)

outMF <- glmer(y.bin ~ x2 + (1 | r4), family=binomial, data=dat)

outMR <- glmer(y.bin ~ x2 + (1 | r4) + (1 | r5), family=binomial, data=dat)

outNq <- glm(y.bin ~ x1 + x2, family=quasibinomial, data=dat)

# Random model test fixed effect
#
RMFE <- pbnm(outM,outMF,nsim=1000)

summary(RMFE)
summary(RMFE,parm=FALSE)
confint(RMFE)
confint(RMFE,parm=FALSE)
plot(RMFE)
plot(RMFE,parm=FALSE)

# Random model test single random effect
#
RMRE <- pbnm(outM,outN,nsim=200)

summary(RMRE)
confint(RMRE)
plot(RMRE)


# Random model test additional random effect
#
RMRE2 <- pbnm(outMR,outM,nsim=100)

summary(RMRE2)
confint(RMRE2)
plot(RMRE2)

# Random model test random covariance
#
RMRC <- pbnm(outM2,outM3,nsim=5)

# RMRC$Mod
summary(RMRC)
summary(RMRC,parm=FALSE)
confint(RMRC)
confint(RMRC,parm=FALSE)
plot(RMRC)
plot(RMRC,parm=FALSE)

# Fixed model test fixed effect
#
FMFE <- pbnm(outF,outFx1,nsim=1000)

# FMFE$Mod
summary(FMFE)
confint(FMFE)
plot(FMFE)

drop1(outF,test="LRT")
summary(outF)$coefficients[2:3,]



# Fixed model test fixed factor effect
#
FMFF <- pbnm(outF,outFr4,nsim=1000)

# FMFF$Mod
summary(FMFF)
confint(FMFF)
plot(FMFF)
