
library(Matrix) # needed by lme4
library(lme4)
library(pbnm)


data(pbDat)
wght <- abs(rnorm(nrow(pbDat))) + 1
mod <- lm(y~x1 + x2 + g1, data=pbDat)
modNull <- lm(y~x2 + g1, data=pbDat)

pbmc <- pbnm(mod,modNull,nsim=10000,test="F",progress=250,seed=836928,
             cores=2,tasks=10)
summary(pbmc)

system.time(
  pb <- pbnm(mod,modNull,nsim=10000,test="F",progress=250,seed=836928,tasks=1)
  )
summary(pb)

system.time(
  pb2 <- pbnm(mod,modNull,nsim=10000,test="F",progress=250,seed=836928,
              cores=1,tasks=10)
  )
summary(pb2)


system.time(
  pbO <- pbnm(mod,modNull,nsim=10000,test="F",progress=250,seed=836928)
)
summary(pbO)


mm <- lmer(y ~ x1 + x2 + (1 | g1), REML=FALSE, data=pbDat)
mmNull <- lmer(y ~ x2 + (1 | g1), REML=FALSE, data=pbDat)


system.time(
  pbm <- pbnm(mm,mmNull,nsim=1000,progress=100,seed=836928,cores=2,tasks=10)
  )
summary(pbm)

system.time(
  pbmB <- pbnm(mm,mmNull,nsim=1000,progress=100,seed=836928)
  )
summary(pbmB)


# test weights
# 


modw <- lm(y~x1 + x2 + g1,weight=wght, data=pbDat)
modwNull <- lm(y~x2 + g1,weight=wght, data=pbDat)

pbwmc <- pbnm(modw,modwNull,nsim=1000,test="F",progress=100,seed=836928,
              tasks=10,cores=2)
summary(pbwmc)

pbw <- pbnm(modw,modwNull,nsim=1000,test="F",progress=100,seed=836928,tasks=10)
summary(pbw)

mmw <- lmer(y ~ x1 + x2  + (1 | g1),weight=wght, REML=FALSE, data=pbDat)
mmwNull <- lmer(y ~ x2  + (1 | g1),weight=wght, REML=FALSE, data=pbDat)

pbmwmc <- pbnm(mmw,mmwNull,nsim=1000,progress=100,seed=836928,tasks=10,cores=2)
summary(pbmwmc)

pbmw <- pbnm(mmw,mmwNull,nsim=1000,progress=100,seed=836928,tasks=10)
summary(pbmw)


#
# test offset
#

offst <- rnorm(nrow(pbDat))

modo <- lm(y~x1 + x2 + g1,offset=offst, data=pbDat)
modoNull <- lm(y~x2 + g1,offset=offst, data=pbDat)

pbomc <- pbnm(modo,modoNull,nsim=1000,test="F",progress=100,seed=836928,
              tasks=10,cores=2)
summary(pbomc)

pbo <- pbnm(modo,modoNull,nsim=1000, test="F",progress=100,seed=836928,tasks=10)
summary(pbo)
