% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbnmFunc.R
\name{summary.pbnm}
\alias{summary.pbnm}
\title{Summarize a parametric bootstrap of nested models}
\usage{
\method{summary}{pbnm}(object, parm = NULL, ...)
}
\arguments{
\item{object}{A "pbnm" object.}

\item{parm}{Set to \code{TRUE} to summarize the parmDist.
Set to \code{FALSE} to summarize the statDist.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class "summary.pbnm".
  
  An object of class "summary.pbnm" is a list containing the
  following components:
  
  \describe{
    \item{"P(>=obs)"}{The p-value from the simulated distribution.
      Set to \code{NA} if any of the simulations had errors.}
    \item{#(>=obs)/runs"}{Only present if "P(>=obs)"==\code{NA}.
      The proportion of the number of models simulated
      where the simulated response model value is 
      greater than or equal to the observed value using m0 and m1.}
    \item{"#(>=obs)/models"}{Only present if "P(>=obs)"==\code{NA}.
      The proportion of the number of models which did not have
      a warning where the simulated response model value is 
      greater than or equal to the observed value using m0 and m1.}
    \item{"#(>=obs)+fails/runs"}{Only present if "P(>=obs)"==\code{NA}.
      The proportion of the number of models simulated
      where the simulated response model value is 
      greater than or equal to the observed value using m0 and m1
      or there was a fit failure.}
   \item{noEst}{The number of simulations in which at least one
      of the two models had an error or a warning.
      These simulation runs are assumed to have an unknown value.}
    \item{fails}{The number of simulations in which at least one
      of the two models failed.}
    \item{warnNull}{The number of simulations in which warning was
      issued during the fit of m0.}
    \item{warnAlt}{The number of simulations in which warning was
      issued during the fit of m1.}
    \item{warn}{The number of simulations in which warning was
      issued during the fit of either m0 or m1.}
    \item{name}{A description of the test which was done in the
      simulations.}
    \item{observed}{The observed value from m0 and m1.}
    \item{testedDropped}{\code{TRUE} if all of the m0 terms are in
      the m1 model.}
    \item{tested}{A character string which is the terms tested.}
    \item{mod}{The call from the m1 parameter to the boot strap.}
    \item{nsim}{The nsim parameter value used in the boot strap.}
    \item{time}{Time and date when boot strap was run.} 
   }
}
\description{
Summary method for class "pbnm"
}
\details{
Returns a p-value for a test from a "pbnm" object
  if there were no errors fitting the simulated responses.
  If there were fit errors, a range of possible p-values
  is returned.
  
  The number of warnings is also returned.
  If the number of are not a small proportion of the number
  of simulations,
  the p-value is questionable.
  When this occurs, it is advised to check the model for issues
  which might be causing the warnings (such as small group sizes.)
}
\examples{
data(pbDat)
mod <- lm(y~x1 + x2 + g1, data=pbDat)
modNull <- lm(y~x2 + g1, data=pbDat)
pb <- pbnm(mod,modNull,seed=836928,test="F")
summary(pb)

}

