% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbnmFunc.R
\name{plot.pbnm}
\alias{plot.pbnm}
\title{Graphic Summary for a Parametric Bootstrap of Nested Models}
\usage{
\method{plot}{pbnm}(x, parm = NULL, ...)
}
\arguments{
\item{x}{A "pbnm" object.}

\item{parm}{Set to \code{TRUE} to summarize the parmDist.
Set to \code{FALSE} to summarize the statDist.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Plots the empirical CDF from a parametric bootstrap of
nested models
}
\details{
Simulated responses with fit errors are not included
  in the CDF.
  Simulated responses with fit warnings are included in the CDF.
}
\examples{
data(pbDat)
mod <- lm(y~x1 + x2 + g1, data=pbDat)
modNull <- lm(y~x2 + g1, data=pbDat)
pb <- pbnm(mod,modNull,seed=836928,test="F")
plot(pb)

}

