% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbnmFunc.R
\name{pbnmRefdist}
\alias{pbnmRefdist}
\title{Runs a parametric bootstrap testing nested models.}
\usage{
pbnmRefdist(m1, m0, nsim = 1000, cores = 1, tasks = 1, seed = NULL,
  test = "LRT", progress = NULL, nestStat = TRUE)
}
\arguments{
\item{m1, m0}{Objects of class lm, glm, lmer, or glmer.}

\item{nsim}{The number of runs to bootstrap.}

\item{cores}{An optional parameter.
The number of cores to use.}

\item{tasks}{An optional parameter.
The number of tasks to split the simulations into.}

\item{seed}{An optional parameter. The seed used to start the simulations.}

\item{test}{to be used by the anova function on the nested models.
"LRT" and "F" are supported.}

\item{progress}{An optional parameter.
If set to an integer, a status message will be issued
at that frequency.}

\item{nestStat}{Defaults to \code{\link[base]{TRUE}}.
If set to \code{\link[base]{FALSE}} no nested statistic will
be collected with each simulation.}
}
\value{
A numeric matrix containing the columns 
  \describe{
    \item{stat}{Value of the test statistic of the nested parameters.
      An \code{NA} element indicates that at least one of the models
      failed to run.}
    \item{parm}{If a single estimated parameter is the difference between
      the two models, this column contains the values of this parameter.
      Otherwise this column is \code{NA}s.}
    \item{errAlt}{An element of this column is \code{TRUE} if at
      least one error was issued when m1 was modeled.
      Otherwise it is \code{FALSE}.}
    \item{errNull}{An element of this column is \code{TRUE} if at
      least one error was issued when m0 was modeled.
      Otherwise it is \code{FALSE}.}
    \item{warnAlt}{An element of this column is \code{TRUE} if
      at least one warning was issued when m1 was modeled.
      Otherwise it is \code{FALSE}.}
    \item{warnNull}{An element of this column is \code{TRUE} if
      at least one warning was issued when m0 was modeled.
      Otherwise it is \code{FALSE}.}

  There is a row for each simulated response.
}
}
\description{
Parametric simulation of new responses, are done using the 
\code{\link[stats]{simulate}} function.
The nested models are tested on these generated responses
using the \code{\link[stats]{anova}} function.
A vector is returned with the elements the anova test statistics.
If a single estimated parameter is the difference between the two
models, a vector of this single parameter is also returned.
}
\details{
Error displays are suppressed.
  Simulations in which at least one of the models generated an
  error are indicated as \code{\link[base]{NA}} in the 
  returned stat and paramater vectors.
  Simulations in which errors are produced are also indicated 
  in the returned errAlt and errNull vectors.

  Warnings are displayed.
  Simulations in which warning are produced are also indicated 
  in the returned warnAlt and warnNull vectors.

  If the difference in the \code{m1} and \code{m0} formula's
  is the addition of a single parameter in the \code{m1} formula,
  the estimate for this single parameter is recorded for each
  simulation.

  If there is a single parameter difference between the two models
  and the nestStat paramter is set to FALSE, then only the \code{m1}
  model will be fit for each simulation.
  This can reduce the run time of the boot strap.

  Models which inherit from "meMod" use refit to create the model
  for the simulated responses.
  Models from lm or glm are created by updating the call formula to
  use the simulated response and then the call is evaluated.
  The simulated response for each run is generated by a call to
  \code{simulate()} using \code{m0} as the reference for the
  distribution of each response.
  Models generated using weights, offset, or subsets
  are supported.  
  
  A separate Random sequence is used for each of the task.
  This allows reproducibility of results when multiple cores are
  used.
  Multiple tasks can be used with a single core.
  
  The number of available cores is determined using the
  \code{\link[parallel]{detectCores}}  function.
  If the number of cores detected is less than the number of cores
  requested in the \code{cores} parameter, the number
  detected is used.
  
  The number of tasks should be set to a value larger than the number
  of cores which will be used.
  If the number of task is smaller, the work is shared only on that
  many cores.
  Load balancing is uses in sharing the work with the other cores.
  So there can be advantages to having tasks be several times the
  size of the number of cores.
}
\examples{
data(pbDat)
mod <- lm(y~x1 + x2 + g1, data=pbDat)
modNull <- lm(y~x2 + g1, data=pbDat)
ref <- pbnmRefdist(mod,modNull,seed=836928,test="F")
obs <- anova(modNull,mod)$"Sum of Sq"[2]
mean(abs(ref[,"stat"])>abs(obs))
# similar value to Wald test in summary()
summary(mod)$coefficients["x1","Pr(>|t|)"]

}

