% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbnm.R, R/pbnmFunc.R
\docType{package}
\name{pbnm}
\alias{pbnm}
\alias{pbnm-package}
\title{pbnm: Parametric Bootstrap Test of Nested Models}
\usage{
pbnm(m1, m0, nsim = 1000, seed = NULL, test = "LRT",
  testContrast = NULL, cores = 1, tasks = 1, progress = NULL,
  nestStat = TRUE, save = FALSE, fileName = NULL,
  pbnmName = "pbmnResults")
}
\arguments{
\item{m1}{Objects of class lm, glm, lmer, or glmer.}

\item{m0}{Objects of class lm, glm, lmer, or glmer.}

\item{nsim}{The number of runs to bootstrap.}

\item{seed}{An optional parameter. The seed used to start the simulations.}

\item{test}{to be used by the anova function on the nested models.
"LRT" and "F" are supported.}

\item{testContrast}{Name of the test being done with the
nested models.
This is useful when the test is other than for parameters
being equal to zero.}

\item{cores}{An optional parameter.
The number of cores to use.}

\item{tasks}{An optional parameter.
The number of tasks to split the simulations into.}

\item{progress}{An optional parameter.
If set to an integer, a status message will be issued
at that frequency.}

\item{nestStat}{Defaults to \code{\link[base]{TRUE}}.
If set to \code{\link[base]{FALSE}} no nested statistic will
be collected with each simulation.}

\item{save}{When \code{TRUE}, save the pbnm object to a file.
This is useful for scripts which include many calls to pbnm.}

\item{fileName}{Quoted string with the name of the file where
the pbnm object is to be saved.}

\item{pbnmName}{The name to be given to the pbnm object saved
in the file.}
}
\value{
An object of class "pbnm".
  
  An object of class "pbnm" is a list containing the following 
  components:
  
  \describe{
    \item{nestStat}{\code{TRUE}, indicates that a nested
      model statistic was collected in the parametric bootstrap.}
    \item{statDist}{Vector of test statistics from simulated
      responses.}
    \item{statObs}{value of test statistic from the fit of m1 and m0.}
    \item{statName}{Name of statistic used in nested model test.}
    \item{oneParm}{\code{TRUE},  indicates that the difference in
      \code{m1} and \code{m0} is the addition of a single parameter.
      If \code{TRUE}, the \code{parmDist}, \code{parmObs}, and
      \code{parmName} are returned in the pbnm object.}
    \item{parmDist}{Only present if oneParm is \code{TRUE}.
      Vector of the dropped parameters value from the
      simulated m1 models.}
    \item{parmObs}{Only present if oneParm is \code{TRUE}.
      Value of the dropped parameters value from the m1 model.}
    \item{parmName}{Only present if oneParm is \code{TRUE}.
      Name of the dropped parameter.}
    \item{errNull}{An element of this column is \code{TRUE} if at
      least one error was issued when m0 was modeled.
      Otherwise it is \code{FALSE}.}
    \item{errAlt}{An element of this column is \code{TRUE} if at
      least one error was issued when m1 was modeled.
      Otherwise it is \code{FALSE}.}
    \item{warnNull}{An element of this column is \code{TRUE} if
      at least one warning was issued when m0 was modeled.
      Otherwise it is \code{FALSE}.}
    \item{warnAlt}{An element of this column is \code{TRUE} if
      at least one warning was issued when m1 was modeled.
      Otherwise it is \code{FALSE}.}
    \item{nsim}{The \code{nsim} parameter value used in the boot strap.}
    \item{seed}{The \code{seed} parameter value used in the bootstrap.}
    \item{time}{Time and date when the bootstrap was run.}
    \item{tested}{A character string which names the is the
      terms tested.}
    \item{testedDropped}{\code{TRUE} if all of the \code{m0} terms
      are in the \code{m1} model.}
    \item{mod}{The call from \code{m1}.}
    \item{nullMod}{The call from \code{m0}.}
  }
}
\description{
The main function is pbnm, which and returns a "pbnm" object.
The boot strap generates the distribution for a single model 
parameter (if the two models differ by only one parameter) and also
for one of the following tests of nested models:
likelihood ratio, restricted likelihood ratio, or F.
The summary, confint, and plot functions are supported for
"pbnm" objects.

Runs the boot strap by calling the pbnmRefdist function.
In addition it returns a pbnm object which is accepted by
summary, confint, and plot.
}
\details{
The pbnm function uses the same parameteric bootstrap
  function as the \code{\link{pbnmRefdist}} function.
  See the help for \code{\link{pbnmRefdist}} more details on
  the parametric bootstrap.
  The pbnm object is created from the returned distributions,
  warning, and error information.

  If save is \code{TRUE}, the pbnm object can be loading into
  an R session using \code{\link[base]{load}}.
  The \code{\link[base]{attach}} function can also be used to
  access the saved pbnm object.

  If the all model terms of \code{m0} are represented in the 
  terms for \code{m1}, the test name is set to the list of 
  additional terms in \code{m1}.
  If the terms being tested can not be determined from the
  terms of the two models, the test name is set to the character
  string provided in the \code{testContrast} parameter.
  If the \code{testContrast} parameter is not provided,
  the test name is then set to indicate that the test is unknown.
}
\examples{
data(pbDat)
mod <- lm(y~x1 + x2 + g1, data=pbDat)
modNull <- lm(y~x2 + g1, data=pbDat)
pb <- pbnm(mod,modNull,seed=836928,test="F")
summary(pb)

}

