% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbnmFunc.R
\name{confint.pbnm}
\alias{confint.pbnm}
\title{Confidence Interval for a parametric bootstrap of nested models}
\usage{
\method{confint}{pbnm}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{A "pbnm" object.}

\item{parm}{Set to \code{TRUE} to summarize the parmDist.
Set to \code{FALSE} to summarize the statDist.}

\item{level}{Confidence level}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A data frame with columns giving
  lower bounds, upper bounds, number of simulations,
  number of simulations with fit failures, and the number
  of simulations with fit warnings.
}
\description{
Empirical confidence intervals for a parametric bootstrap of
nested models
}
\details{
Provides the confidence interval of the parameter or
  test statistic assuming the null model is the true model.
  This is different than what \code{confint(mod)} does,
  which is a confidence interval for the parameter or test
  statistic given the observed data.

  The fit errors are assumed to have values both negative
  infinity and positive infinity.
  This provides the most conservative interval when there
  are fit errors.
  
  The warnings are ignored in the calculations of the interval.
}
\examples{
data(pbDat)
mod <- lm(y~x1 + x2 + g1, data=pbDat)
modNull <- lm(y~x2 + g1, data=pbDat)
pb <- pbnm(mod,modNull,seed=836928,test="F")
confint(pb)

}

