# generate a dataset
#
n  <- 100
n1 <- 12
n2 <- 7
set.seed(62591415)
x1 <- rnorm(n)
x2 <- rnorm(n)
bin <- rep(NA,n)
error <- rnorm(n,0,1)
g1 <- factor( rep(LETTERS[seq(1,n1)],n)[1:n] )
effg1 <- rnorm(length(levels(g1)))[as.numeric(g1)]
g2 <- factor( rep(letters[seq(1,n2)],n)[1:n] )
y <- -20 + 10 * x1 - 40 * x2 + 90 * error + 70 * effg1
odds <- exp(y)
prob <- ifelse(odds == Inf,1, odds / (1 + odds) )
for (i in 1 : n){
  bin[i] <- rbinom(1,1,prob[i])
  }
datUnsorted <- data.frame(y,bin,x1,x2,g1,g2)
pbDat <- datUnsorted[order(g1,g2),]
save(pbDat,file="data/pbDat.RData")
